/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : cpupdefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 7.11.98
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef CPUPDEFS_H_INCLUDED                               
#define CPUPDEFS_H_INCLUDED


#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * definitions for CPU port
 * --------------------------------------------------------------- */

/* --------------------------------------------------------------------------
 * Physical addresses and offsets.
 * -------------------------------------------------------------------------- */

#define CPUPORT_MAX_DATA_OFFSET 0x0000ffffUL
#define CPUPORT_MAX_DATA_SIZE   CPUPORT_MAX_DATA_OFFSET + 1


/* limits */
#define CPUPORT_MAX_DEVICE  1
#define CPUPORT_MIN_WIDTH   1  
#define CPUPORT_MAX_WIDTH   2


/* ---------------------------------------------------------------
 * Type Definitions for CPU Port Properties
 * --------------------------------------------------------------- */

#define B_CPUPROP_SIZE		 3
/* #define B_CPPROP_SIZE		3 */ /* TODO; get rid of this one */

CLI typedef enum {
  B_CPU_MODE,        /* @mode  */
  B_CPU_PROTOCOL,    /* @proto */
  B_CPU_RDYTYPE      /* @rdy   */
} b_cpuproptype;


/* possible values for mode property */
/* NOTE; B_CM_SLAVE is not implemented ??? */

/* Attention this has to remain in sync with minibest/include/sidecpu.h */

CLI /* DEF_START ~G_CPUPORT_MODE */
#define B_CM_MASTER            0x0  /* @master */
#define B_CM_SLAVE             0x1  /* @slave */
#define B_CM_DISABLED          0x2  /* @disabled */
CLI /* DEF_END */

/* possible values for protocol property */
CLI /* DEF_START ~G_CPUPORT_PROTOCOL */
#define B_CP_INTEL             0x0  /* @intel */
#define B_CP_M68000            0x1  /* @m68 */
CLI /* DEF_END */

CLI /* DEF_START ~G_CPUPORT_RDYTYPE */
#define B_CR_EXTERNAL          0x0  /* @external */
#define B_CR_AUTO              0x1  /* @auto */
CLI /* DEF_END */


/* ---------------------------------------------------------------
 * Type Definitions for Static IO Port Programming Functions
 * --------------------------------------------------------------- */

#define B_STATIOPROP_SIZE	 8	/* actually, it's the pin number, CZ */

CLI typedef enum {
  B_STAT_PINMODE   /* @pinmode */
} b_staticproptype;


/* ---------------------------------------------------------------
 * Defines for Static IO Port Programming Functions
 * --------------------------------------------------------------- */

CLI                             /* DEF_START ~G_G15 */
#define B_PMD_INPONLY          0x0  /* @inponly */
#define B_PMD_TOTEMPOLE        0x1  /* @totempole */
#define B_PMD_OPENDRAIN        0x2  /* @opendrain */
CLI                             /* DEF_END */





#endif




